
#include <ESP8266WiFi.h>
#include <WiFiClient.h>
#include <ESP8266WiFiMulti.h> 
#include <ESP8266mDNS.h>
#include <ESP8266WebServer.h>   // Include the WebServer library

const int LED_GREEN = 2;
const int LED_RED = 4;

ESP8266WiFiMulti wifiMulti;     // Create an instance of the ESP8266WiFiMulti class, called 'wifiMulti'

ESP8266WebServer server(80);    // Create a webserver object that listens for HTTP request on port 80

void handleRoot();              // function prototypes for HTTP handlers
void handleNotFound();

void setup(void){

   pinMode(LED_RED, OUTPUT);
  pinMode(LED_GREEN, OUTPUT);
  
  Serial.begin(57600);         // Start the Serial communication to send messages to the computer
  delay(10);
  Serial.println('\n');

  wifiMulti.addAP("YOURWIFISSID", "Your-wifi-password");   // add Wi-Fi networks you want to connect to


  Serial.println("Connecting ...");
  int i = 0;
  while (wifiMulti.run() != WL_CONNECTED) { // Wait for the Wi-Fi to connect: scan for Wi-Fi networks, and connect to the strongest of the networks above
    delay(250);
    Serial.print('.');
  }
  Serial.println('\n');
  Serial.print("Connected to ");
  Serial.println(WiFi.SSID());              // Tell us what network we're connected to
  Serial.print("IP address:\t");
  Serial.println(WiFi.localIP());           // Send the IP address of the ESP8266 to the computer

  if (MDNS.begin("esp8266")) {              // Start the mDNS responder for esp8266.local
    Serial.println("mDNS responder started");
  } else {
    Serial.println("Error setting up MDNS responder!");
  }

  server.on("/", handleRoot);               // Call the 'handleRoot' function when a client requests URI "/"
  server.on("/red", handleRed);  
  server.on("/greenoff", handleGreenOff);  
  server.on("/redoff", handleRedOff);  
  server.on("/green", handleGreen);
  server.on("/off", handleOff);  
  server.onNotFound(handleNotFound);        // When a client requests an unknown URI (i.e. something other than "/"), call function "handleNotFound"

  server.begin();                           // Actually start the server
  Serial.println("HTTP server started");
}

void loop(void){
  server.handleClient();                    // Listen for HTTP requests from clients
}


// author apicquot from https://forum.arduino.cc/index.php?topic=228884.0
String IpAddress2String(const IPAddress& ipAddress)
{
  return String(ipAddress[0]) + String(".") +\
  String(ipAddress[1]) + String(".") +\
  String(ipAddress[2]) + String(".") +\
  String(ipAddress[3])  ; 
}

void handleRoot() {

   String message = String("Tally light\nIP: ");
   message.concat(IpAddress2String(WiFi.localIP()));
   message.concat("\nSSID: " + WiFi.SSID());
   //String("Tally light\nIP: ") + WiFi.localIP() as String + String("SSID: ") + String(WiFi.SSID())
  server.send(200, "text/plain", message);   // Send HTTP status 200 (Ok) and send some text to the browser/client
}

void handleRed() {
  digitalWrite(LED_GREEN, LOW);
  digitalWrite(LED_RED, HIGH);
  server.send(200, "text/plain", "OK");   // Send HTTP status 200 (Ok) and send some text to the browser/client
}

void handleGreen() {
 digitalWrite(LED_GREEN, HIGH);
 digitalWrite(LED_RED, LOW);
  server.send(200, "text/plain", "OK");   // Send HTTP status 200 (Ok) and send some text to the browser/client
}

void handleOff() {
  digitalWrite(LED_GREEN, LOW);
  digitalWrite(LED_RED, LOW);
  server.send(200, "text/plain", "OK");   // Send HTTP status 200 (Ok) and send some text to the browser/client
}

void handleRedOff() {
  digitalWrite(LED_RED, LOW);
  server.send(200, "text/plain", "OK");   // Send HTTP status 200 (Ok) and send some text to the browser/client
}

void handleGreenOff() {
  digitalWrite(LED_GREEN, LOW);
  server.send(200, "text/plain", "OK");   // Send HTTP status 200 (Ok) and send some text to the browser/client
}

void handleNotFound(){
  server.send(404, "text/plain", "404: Not found"); // Send HTTP status 404 (Not Found) when there's no handler for the URI in the request
}
